% Menu Statement Example Script

% set up vectors for lengths, widths, and heights
lengths = [12 5.375 11 11.875];
widths = [12 8.675 8.5 3.375];
heights = [5.5 1.675 5.5 13.675];

% allow user to select box
choice = menu('Please select a package:','Option 1: L: 12", W: 12", H: 5.5"',...
                                         'Option 2: L: 5.375", W: 8.675", H: 1.675"',...
                                         'Option 3: L: 11", W: 8.5", H: 5.5"',...
                                         'Option 4: L: 11.875", W: 3.375", H: 13.675"');

% select values from vectors based on user choice and compute volume and
% girth
volume = lengths(choice)*widths(choice)*heights(choice);
girth = sqrt(lengths(choice)^2+widths(choice)^2+heights(choice)^2);

% display results
fprintf('The chosen box has a volume of %0.4f inches^3 and a girth of %0.4f inches.\n',volume,girth);
